# Byteonic Intake WordPress Plugin Guide

**Version 1.1.0**

This guide covers how to install, configure, and use the Byteonic Intake plugin to connect your WordPress forms (Gravity Forms, Contact Form 7, WPForms, Elementor, Divi) to the Byteonic Intake platform.

## 1. Installation

1.  **Download**: Log in to your Byteonic Intake Dashboard (`intake.byteoniclabs.com`).
2.  **Navigate**: Go to **Plugins & Integrations** in the sidebar.
3.  **Get Plugin**: Click the **Download** button on the WordPress Plugin card to get the `intake-forms.zip` file.
4.  **Upload to WordPress**:
    *   Go to your WordPress Admin.
    *   Navigate to **Plugins > Add New**.
    *   Click **Upload Plugin** and select the `.zip` file.
    *   Click **Install Now** and then **Activate**.

## 2. Configuration

1.  **Open Settings**:
    *   You will see a **Byteonic Intake** menu item in your WordPress admin sidebar.
    *   Alternatively, go to **Plugins**, find "Byteonic Intake," and click **Settings**.
2.  **Connect**:
    *   Enter your **API Key** from the Byteonic Dashboard (Settings > API Keys).
    *   Click **Save Settings**.
    *   If successful, you will see a "Connected successfully!" message and a list of available forms.

## 3. Integrations

The plugin integrates directly into your favorite form builders. You do not need to leave the builder to connect a form!

### Gravity Forms
1.  Edit any Form in Gravity Forms.
2.  Go to **Settings > Byteonic Intake**.
3.  Check **Enable Integration**.
4.  Select the **Target Form** from Byteonic.
5.  **Map Fields**: Select which Gravity Form field corresponds to each Byteonic field.
6.  Click **Save Settings**.

### Contact Form 7
1.  Edit a Contact Form.
2.  Click the **Byteonic Intake** tab (next to "Mail" and "Messages").
3.  Check **Enable Integration**.
4.  Select a **Target Form**.
5.  **Map Fields**: Match your CF7 "mail tags" (e.g., `[your-name]`) to the Byteonic fields.
6.  **Save** the Contact Form.

### WPForms
1.  Edit a form in the WPForms Builder.
2.  Go to **Settings > Byteonic Intake** in the left panel.
3.  Check **Enable Integration**.
4.  Select the **Target Form**.
5.  **Map Fields** using the dropdowns.
6.  **Save** the form.

### Elementor Forms (Coming Soon)
*   Look for "Actions After Submit" -> "Byteonic Intake".
*   A new "Byteonic Intake" section will appear for mapping.

### Divi Forms (Coming Soon)
*   Open the Contact Form Module settings.
*   Look for "Byteonic Intake" integration options.

## 4. Troubleshooting

*   **"Connection Failed"**: Check if your API Key is correct and has not been revoked.
*   **"Unknown API Error"**: Ensure the backend server is reachable.
*   **Submissions not showing**: Check the form mapping and ensure "Enable Integration" is checked.
*   **Logs**: Gravity Forms users can check the Logging settings if enabled.

---
**Need Help?** Contact support at support@byteoniclabs.com.
