<?php
/**
 * Plugin Name: Byteonic Intake
 * Plugin URI:  https://intake.byteoniclabs.com/
 * Description: Seamlessly integrate your WordPress forms (Gravity Forms, Contact Form 7, WPForms) with Byteonic Intake.
 * Version:     1.2.0
 * Author:      Byteonic Labs
 * Author URI:  https://byteoniclabs.com
 * License:     GPL-2.0+
 * Text Domain: byteonic-intake
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Define Constants
define('BYTEONIC_INTAKE_VERSION', '1.2.0');
define('BYTEONIC_INTAKE_PATH', plugin_dir_path(__FILE__));
define('BYTEONIC_INTAKE_URL', plugin_dir_url(__FILE__));
define('BYTEONIC_API_BASE_URL', 'https://intake.byteoniclabs.com/api/external');

// Include Core Classes
require_once BYTEONIC_INTAKE_PATH . 'includes/class-byteonic-api.php';
require_once BYTEONIC_INTAKE_PATH . 'includes/class-byteonic-admin.php';

// Integrations
require_once BYTEONIC_INTAKE_PATH . 'includes/integrations/class-gravity-forms.php';
require_once BYTEONIC_INTAKE_PATH . 'includes/integrations/class-cf7.php';
require_once BYTEONIC_INTAKE_PATH . 'includes/integrations/class-wpforms.php';
require_once BYTEONIC_INTAKE_PATH . 'includes/integrations/class-fluent-forms.php';


/**
 * Initialize the plugin
 */
function byteonic_intake_init()
{
    // Initialize API Wrapper
    // We defer key retrieval to inside the class to support dynamic updates
    $api = new Byteonic_API();

    // Initialize Admin UI
    if (is_admin()) {
        new Byteonic_Admin($api);
    }

    // Initialize Integrations
    // These classes should check if their respective parent plugins are active
    new Byteonic_Gravity_Forms($api);
    new Byteonic_CF7($api);
    new Byteonic_WPForms($api);
    new Byteonic_Fluent_Forms($api);

}
add_action('plugins_loaded', 'byteonic_intake_init');
