<?php
/**
 * Byteonic Intake Uninstall
 *
 * Fired when the plugin is uninstalled.
 *
 * @package Byteonic_Intake
 */

// If uninstall not called from WordPress, exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('byteonic_intake_api_key');
delete_option('byteonic_intake_settings');

// Clean up any transients
delete_transient('byteonic_intake_forms_cache');

// Note: We do not delete form-specific meta data from Gravity Forms, WPForms, etc.
// as users may want to reinstall the plugin and retain their mappings.
// If you want to clean those up, uncomment the following:

/*
// Clean Gravity Forms meta (if GF exists)
if ( class_exists( 'GFAPI' ) ) {
    $forms = GFAPI::get_forms();
    foreach ( $forms as $form ) {
        gform_delete_meta( $form['id'], 'byteonic_intake_settings' );
    }
}

// Clean Contact Form 7 meta
global $wpdb;
$wpdb->query( "DELETE FROM {$wpdb->postmeta} WHERE meta_key = 'byteonic_intake_settings'" );
*/
